# Excavation of Days — local calendar journal with built‑in privacy

**Excavation of Days** is a local, file-based calendar journal that stores each day as a **single JSON file** inside a story folder.  
It runs fully offline in your browser using `index.html` + `d3.v7.min.js`—no server, no accounts.

- **Workspace** = the folder you choose on your computer (contains your stories)
- **Story** = a subfolder inside the workspace (your journal universe, e.g. *“My Story”*)
- **Note** = a file named `YYYY-MM-DD.json` inside a story

For detailed acceptance criteria and UI behavior, see **`User Stories.md`**.

---

## Quick start

1. Put `index.html` (and `d3.v7.min.js`) in a folder you trust.
2. Open `index.html` in Chrome/Edge (recommended).
3. Click **New story**  
   - Pick (or confirm) a **workspace folder** when the browser asks.
   - Give the story a name.
   - Choose **Plain JSON** or **Encrypted** (optional).
4. Click any day to open the note dialog, write a note, pick color/tarot, then **Save**.

Tip: If the app finds a previously used workspace, you may get a **“Continue with saved workspace”** gate.

---

## Main UI concepts

### Calendar view
- Year slider to view one year at a time.
- Optional controls to show/hide additional years.
- Day cells can be visually marked by a saved **color**.
- Hover tooltips can show note content (see “Tooltips” below).

### Stories panel
- Lists all story folders in the selected workspace.
- Each story shows whether it is:
  - **Plain JSON**, or
  - **Encrypted (locked/unlocked)**

Actions you can use:
- **New story**
- **Switch workspace**
- **Rescan active story** (re-read files from disk)
- **Reset app state** (forget browser-held state, does not delete files)

### Note dialog (per date)
- Edit note text, pick a color, and optionally select tarot.
- Navigate to previous/next day.
- Move a note to another date (renames the file).

---

## Folder structure

Workspace example:

```
MyWorkspace/
  My Story/
    story.settings.json
    2026-01-12.json
    2026-01-13.json
  Another Story/
    story.settings.json
    2025-11-02.json
```

- `story.settings.json` stores story-level settings (including encryption parameters and an optional key hint).
- `YYYY-MM-DD.json` is the note file for that date.

---

## Saving model

- One day = one file: `YYYY-MM-DD.json`.
- The app reads the story folder to build the calendar state.
- **Move** renames a note file to another date and can overwrite with confirmation.

If your browser **does not** support saving directly into a folder (File System Access API), the app will fall back to **downloading** note files instead of writing them into the workspace.

---

## Privacy and encryption

Encryption is optional and happens **in the browser** using Web Crypto.

### Story encryption (encrypts all story-scope notes)
- When creating a story, you can choose:
  - **Plain JSON**, or
  - **Encrypted**
- You unlock an encrypted story using a **Story key** (passphrase).
- The story uses:
  - **PBKDF2 (SHA‑256)** with **200000 iterations**
  - **AES‑256‑GCM** for note payload encryption

When story encryption is enabled, saving a normal note encrypts:
- note text
- chosen color
- chosen tarot
- metadata like `updatedAt`

#### Unlock / lock
- Locked story: notes stay encrypted; the UI will ask you to unlock before reading/saving story-scope notes.
- You can optionally **remember the Story key for this session** (stored in `sessionStorage`).

#### Disable encryption (decrypt story-scope notes)
If a story is encrypted and unlocked, you can choose **Disable encryption**:
- All **story-scope** encrypted notes are decrypted and saved back as **plain JSON**
- Notes that use **note-specific override encryption** stay encrypted (you must unlock them individually)
- The story becomes plain JSON again

#### Enable encryption later (encrypt existing plaintext notes)
If a story is plain JSON, you can **Enable encryption** later:
- You choose a Story key and optional key hint
- The app encrypts **all existing plaintext notes** in the story
- Existing **note-specific override** notes are left as-is

#### Change story key (key rotation)
If a story is encrypted and unlocked, you can **Change story key**:
- Re-encrypts story-scope notes with a new Story key
- Note-specific override notes are not changed

### Note-specific encryption override (for extra sensitive notes)
Even in an encrypted story, you can encrypt a single note with its **own key** (override).
This is useful for notes you do not want unlocked just because the story is unlocked.

- Override notes store their own parameters in the note file:
  - PBKDF2 (SHA‑256) with **200000 iterations**
  - AES‑256‑GCM
  - A per-note random salt
  - Optional **note key hint** (hint only)

#### Unlock an override note
If the current day’s note is note-encrypted, you can unlock it by entering the **note key**.

#### Disable note-specific encryption
After unlocking an override note, you can **Disable note-specific encryption**:
- The note is saved back without the override.
- If the story is encrypted, the note will then be saved using **story-scope encryption**.
- If the story is plain, it becomes **plain JSON**.

### Password visibility (“Show”)
Story key and note key inputs behave like password fields (hidden characters).  
You can toggle **Show** to reveal/hide what you typed.

---

## Tooltips (privacy-aware)

When a day has a note:
- If the story is **unlocked** (or not encrypted at all), hovering a day can show a tooltip with the note content.
- If the note uses **note-specific override encryption**, the tooltip is **disabled** (no content is shown).

---

## Browser requirements and limitations

Recommended: **Chrome / Edge**.

Features used:
- **File System Access API** for writing directly into your workspace folder (fallback: downloads).
- **Web Crypto (crypto.subtle)** for encryption.

Encryption may require a **secure context** in some browsers:
- If `file://` blocks crypto, serve the folder via `http://localhost` (simple local server) or use a browser that allows Web Crypto for local files.

---

## Practical safety tips

- Use a strong Story key (passphrase).
- Use note override keys only when you truly need “extra lock” for a single day.
- Avoid “Remember for this session” on shared computers.
- Back up your workspace by copying the folder (notes are plain files; encryption does not replace backups).

---

## License and responsibility

Free - as in freedom - software.

This is a local tool without a server. You are responsible for:
- keeping keys safe
- backing up files
- choosing a suitable browser and security context
